//>>>>>>>>>>>>>>>>>>>>>>>>
//sampler.c
//>>>>>>>>>>
//This file contains the Sampler Task, which runs when needed and blocks itself when not.
//This task works by waiting for the LTCTWR_PARAMETER struct to be populated with data and then is unblocked.
//
//When unblocked, it creates a Timer task, and then queries the LTCTWR_PARAMETER struct to see which channels need to be read.
//Opens a file pointer to Destination file and populates it with the first line
//
//If necessary, it notes which channels need to be written to by opening a file pointer to the Source file.
//
//The task then runs a loop for numsamples times:
//
//	Find the sampling period, and then configures the timer accordingly.
//	Read the source file to find DAC data.
//	Query all the ADCs and write results to file.
//	If required, Write source data to the DACs.
//	Wait until timer is expired.
//
//	If timer expires before the above is done, ignore it and write a debug message.
//
//When everything is done, destroy Timer Task, and close all file pointers.
//



//Include this line first
#include <main.h>

#include <spi.h>

//Before this line.
#if defined BSP_TWR_K60D100M 
#include <spi_dspi.h> //Modified-for-Kinetis
#else
#include <spi_mcf5xxx_qspi.h>
#endif


//LTC Board Specific Headers
#include <ltctwrutils.h>
#include <ltctwrboard.h>
#include "lwsem.h"

//Logging Functionality
#include <logging.h>
#include <string.h>



//USB headers
#include <usb_file.h>


//Timer
#include <timer.h>
#define TIMER_TASK_PRIORITY  2
#define TIMER_STACK_SIZE     1000



extern LWSEM_STRUCT  USB_Stick;
//LWSEM_STRUCT  USB_Stick;
uint_32 samplerprogresscount = 0;
boolean working;

pointer my_pt;
_task_id my_id;
void loop_done_isr(_timer_id, pointer, MQX_TICK_STRUCT_PTR);

//Function to be called with the timing loop is done
void loop_done_isr
   (
      _timer_id id, 
      pointer data_ptr, 
      MQX_TICK_STRUCT_PTR tick_ptr
   )
{
   if(!working) 
   {
   	_task_ready(my_pt);
   }
   else 
   {
   	working = FALSE;
   	printf("Timer Expired, Period too short!\n");
   }
   
   
}



/*TASK*-----------------------------------------------------------------
*
* Function Name  : Sampler_task
* Comments       :
*    This task is called by the SHELL to take Samples.
*
*END------------------------------------------------------------------*/
void Sampler_task(uint_32 temp) 
{
   uint_8  i;
   uint_32 buffer;
   uint_32 isamp;
   FILE_PTR  src_fp;
   FILE_PTR  dest_fp;
   
   char		ReadBuffer[76];
   
   uint_32	SpanTo2704;
   uint_32  ValuesTo2704[4];
   uint_32  ValuesTo2600[8];
   
   
   char     Message[LOG_MESSAGE_SIZE];
   
   LTCTWR_PARAMS_PTR LTCTWR_Params_Ptr;
   MQX_TICK_STRUCT dticks;
   _timer_id       my_timer;
   
   
   my_id = _task_get_id_from_name("Sampler");  //Only good way to get the id
   my_pt = _task_get_td(my_id);
   
   
   while(1)
   {
   
	   _task_block();
	   
	   printf("Sampler spawned... 0x%08x\n", temp);
	   
	   LTCTWR_Params_Ptr = LTCTWR_GetParameters();
	   _time_delay(500);
	   samplerprogresscount = 0;
	   
	   //Create the Timer Task
	   _timer_create_component(TIMER_DEFAULT_TASK_PRIORITY, 1024);
	   



	   if (LTCTWR_Params_Ptr->srcname[0] != 0) {
		   //Read from the Source File
		   	if(_lwsem_poll(&USB_Stick)) {
		   	   //printf("Attempting to Open...\n");
		   	   src_fp = fopen(LTCTWR_Params_Ptr->srcname,"r");  //DATA_FILE
		       //The "r" here means read
		       
		       if (src_fp == NULL) 
	            {
	            	printf("No file?\n");
	            }
			       
		       fgets (ReadBuffer , 76 , src_fp);  //Read the headings out
		       printf("Read String: %s\n", ReadBuffer);
		   		_lwsem_post(&USB_Stick);
		   	}
		   	else
		   	{
		   		printf("USB not free...\n");
		   	}

	   }

	   /////////////////////////////	   
	   //Set up pointer to Destination File

	   _lwsem_wait(&USB_Stick);
	   dest_fp = fopen(LTCTWR_Params_Ptr->destname,"a");  //LOG_FILE
	   fseek(dest_fp,0,IO_SEEK_END);
	   
	   //Populate the first line
	   write(dest_fp, "Channels:, ", 11);
	   
	   for (i=0; i<LTCTWR_Params_Ptr->numchannels1859; i++)
	   {
	      sprintf(ReadBuffer,"1859 %d, ",LTCTWR_Params_Ptr->channels1859[i]);
	      sprintf(Message,"1859 %d, ",LTCTWR_Params_Ptr->channels1859[i]);
	      write(dest_fp, Message, strlen(Message));
	   }
	   
	   for (i=0; i<LTCTWR_Params_Ptr->numchannels2498; i++)
	   {
	      sprintf(Message,"2498 %d, ",LTCTWR_Params_Ptr->channels2498[i]);
	      write(dest_fp, Message, strlen(Message));
	   }
	   
	   write(dest_fp, "\n", 1);
	   
	   _lwsem_post(&USB_Stick);
	   //Done with Destination file
	      
	   
	   
	   //////////////////////////////////////////////////////////////////////////////////////////
	   //Start Sampling and Reading
	   for (isamp=0; isamp < LTCTWR_Params_Ptr->numsamples; isamp++) 
	   {
	   	  //Test the decoder writing functionality
		  //set_decoder_channel(isamp, LTCTWR_Params_Ptr);
		     
	   	  working = TRUE;
	   	  //Add timer to timer queue
	   	  //Make it expire in LTCTWR_Params_Ptr->samplingperiod
	   	  _time_init_ticks(&dticks, 0);
	   	  _time_add_msec_to_ticks(&dticks, LTCTWR_Params_Ptr->samplingperiod);
	   	  
	   	  my_timer =  _timer_start_oneshot_after_ticks(loop_done_isr, 0, TIMER_ELAPSED_TIME_MODE, &dticks);
	   	  
	   	  
	   	  	  
	   	  ///////////////////////////////////////////////////
	   	  //If we actually want DAC function
	   	  if ((LTCTWR_Params_Ptr->srcname[0] != 0)){ //&& (isamp < (LTCTWR_Params_Ptr->numsamples)-1)) {
	   	  	

		   	_lwsem_wait(&USB_Stick);


			fgets (ReadBuffer , 76 , src_fp);
			fgets (ReadBuffer , 76 , src_fp);
            sscanf (ReadBuffer,"%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d",&SpanTo2704,&ValuesTo2704[0],&ValuesTo2704[1],&ValuesTo2704[2],&ValuesTo2704[3],&ValuesTo2600[0],&ValuesTo2600[1],&ValuesTo2600[2],&ValuesTo2600[3],&ValuesTo2600[4],&ValuesTo2600[5],&ValuesTo2600[6],&ValuesTo2600[7]);

   			
             // Indicate that the USB stick is no longer in use
             _lwsem_post(&USB_Stick);
          
	   	  } //End read into DAC buffer
			//////////////////////////
 
	   
	   
	      ////////////////////////////////////////
	      //Start Reading ADCs
	      
	   	  _lwsem_wait(&USB_Stick);
	   	  fseek(dest_fp,0,IO_SEEK_END);
	   
	      //Write first column   
	      sprintf(Message,"Sample %d, ", isamp+1);
	      
	      //Log(Message);
		  write(dest_fp, Message, strlen(Message));
		  
		  	   	
	   	  //Change CS pins to talk to 1859
	   	  set_decoder_channel(LTC1859_channel, LTCTWR_Params_Ptr);
	   	  if (LTCTWR_Params_Ptr->numchannels1859 >= 1) 
	   	  {
	   	  	  
		   	  for (i=0; i<=LTCTWR_Params_Ptr->numchannels1859; i++)
		   	  {
		   	  	lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
		   	  	buffer = send_receive_LTC1859 (LTCTWR_Params_Ptr->channels1859[i], LTCTWR_Params_Ptr->span1859, LTC1859_POWER_ON, LTCTWR_Params_Ptr->spifd);
		   	  	lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
		   	  	sprintf(Message,"%d, ", (buffer >> 16));

		   	  	if(i != 0) 	write(dest_fp, Message, strlen(Message)); //Log(Message);

		   	  }
	   	  }
	   	  
	   	  //Change CS pins to talk to 2498
	   	  set_decoder_channel(LTC2498_channel, LTCTWR_Params_Ptr);
	   	  if (LTCTWR_Params_Ptr->numchannels2498 >= 1) 
	   	  {
		   	  for (i=0; i<=LTCTWR_Params_Ptr->numchannels2498; i++)
		   	  {
		   	  
		   	  	if(i != 0)  _time_delay(150);
		   	  	lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
		   	  	buffer = send_receive_LTC2498 (LTCTWR_Params_Ptr->channels2498[i], LTCTWR_Params_Ptr->setting2498, LTCTWR_Params_Ptr->spifd);
		   	  	lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
		   	    sprintf(Message,"%d, ", (buffer));

		   	  	if(i != 0)  write(dest_fp, Message, strlen(Message));  //Log(Message);
		   	  }
	   	  		   	  
	   	  }
	   	  
	   	  
	   	  if ((LTCTWR_Params_Ptr->numchannels1859 >= 1) || (LTCTWR_Params_Ptr->numchannels2498 >= 1) )
	   	  {
	   	  	fflush (LTCTWR_Params_Ptr->spifd);
	   	  }
	   	

	   	  write(dest_fp, "\n", 1);
	   	  
	   	  _lwsem_post(&USB_Stick);
	   	  
	   	  
	   	  samplerprogresscount++;
	   	  //End Reading from ADCs and Writing to File
	   	  
	   	  
	   	  
	   	  /////////////////////
	   	  //Write to DACs
	   	  //////////////////////
	   	  if (LTCTWR_Params_Ptr->srcname[0] != 0) {
	   	  	set_decoder_channel(LTC2704_channel, LTCTWR_Params_Ptr);
	   	  	for(i=0; i<4; i++) 
	   	  	{
	   	  		if(ValuesTo2704[i] < 65536) 
	   	  		{
	   	  			lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
	   	  			send_receive_LTC2704 (LTC2704_CMD_WRITE_SPAN_N, LTC2704ChannelSelect[i], LTC2704SpanSelect[SpanTo2704], LTCTWR_Params_Ptr->spifd);
	   	  			lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
	   	  			lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
	   	  			send_receive_LTC2704 (LTC2704_CMD_WRITE_CODE_N_UPDATE_N, LTC2704ChannelSelect[i], ValuesTo2704[i], LTCTWR_Params_Ptr->spifd);
	   	  			lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
	   	  		}
	   	  	}
	   	  	
	   	  	set_decoder_channel(LTC2600_channel, LTCTWR_Params_Ptr);
	   	  	for(i=0; i<8; i++) 
	   	  	{
	   	  		if(ValuesTo2600[i] < 65536) 
	   	  		{
	   	  			lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
	   	  			send_receive_LTC2600 (LTC2600_CMD_WRITE_UPDATE_N, LTC2600ChannelSelect[i], ValuesTo2600[i], LTCTWR_Params_Ptr->spifd);
	   	  			lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
	   	  		}  		
	   	  	}
	   	  }
	   	  fflush (LTCTWR_Params_Ptr->spifd);
	   	  ////////////////////////
	   	  //End Write to DAC
	   	  
	   	  
	   	  
	   	  
	   	  //////////////////
	   	  //Delay
	   	  //Implemented by ISR

	   	  if(working) 
	   	  {
	   	  	working = FALSE;
	   	  	_task_block();  //The timer done ISR should free this
	   	  }
	   	  
	   	  //////////////////

	   }

////////////////SPECIAL REV D EDIT ////////////////////////////////
#if defined BSP_TWR_K60D100M
#if defined K60N512_REV_D
            set_decoder_channel(0x01, LTCTWR_Params_Ptr); // bring GPIO7 high to bring Ethernet transceiver out of reset
	    _time_delay(2500);			          // allow time for Ethernet transceiver to come out of reset
#endif            
#endif
////////////////END SPECIAL REV D EDIT //////////////////////////////// 	   
           
	   _timer_cancel(my_timer);
	   
	   //Finish off
	   _lwsem_wait(&USB_Stick);
	   write(dest_fp, "\n\n", 2);
	   fclose(dest_fp);
	   if (LTCTWR_Params_Ptr->srcname[0] != 0) {
       	fclose(src_fp);	   // close the source file
	   }
	   _lwsem_post(&USB_Stick);
           
                       
	   
	   
	   printf("Sampler exiting...");
            
	   
   }
}  
   
